/*
 *  spi-algo-mn2ws.h i2c driver algorithms for Panasonic MN2WS series adapters
 *    (C) Copyright 2018 Panasonic Corporation.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef SPI_MN2WS_INTERNAL_H__INCLLUDED /* [ */
#define SPI_MN2WS_INTERNAL_H__INCLLUDED 1
#define PORT_CS 1							// CS桡1:PIO桡0:ϡɥ
//#define PINSEL 1							// PINSELꡡ1:ꡡ0:ʤ
//#define REGCHK 1							// 쥸å1:ꡡ0:ʤ
//#define DUMMY_12345678
//#define DUMMY_B8A2E4F1
//#define DUMMY_allF

#include <linux/cciss_ioctl.h>
#include <linux/wait.h>
#include "spi.h"

/* initial value */
#define SPI_TX_LSBFIRST			0
#define SPI_RX_LSBFIRST			0
#define SPI_TX_BITS_PER_WORD	32
#define SPI_RX_BITS_PER_WORD 	32
#define SPI_CLK_DELAY			0
#define SPI_CLK_RATE			4
#define SPI_CSPOL				1
#define SPI_CSSTRT				0
#define SPI_WDLEN				32
#define SPI_TX_DATA_ORDER		0
#define SPI_RX_DATA_ORDER		0
#define SPI_TX_DATA_DELAY		0
#define SPI_RX_DATA_DELAY		0
#define SPI_TX_FIFO_TH			8
#define SPI_RX_FIFO_TH			0

#define SPI_MN2WS_CKS_INIT		(0x0004)
#define SPI_MN2WS_TXWDS_INIT	(0x2020)
#define SPI_MN2WS_RXWDS_INIT	(0x0020)
#define SPI_MN2WS_FPS_INIT		(0x8020)
#define SPI_MN2WS_FC_INIT		(0x0800)

#define SPI_REG_BASE			(0x54006000UL)
#define SPI_OFFSET(ch)			(0x100 * ch)

#define SPI_MN2WS_0_BASE		(SPI_REG_BASE + SPI_OFFSET(0))	/* SPI #0 */
#define SPI_MN2WS_1_BASE		(SPI_REG_BASE + SPI_OFFSET(1))	/* SPI #1 */

#define IO_SIZE					((2 * 11) + (4 * 2))	/* 16bit * 11 Register + 32bit * 2 Register = 30 Byte */

/*----- Register Offset -----*/
#define SPI_MN2WS_CTL			(0x00)
#define SPI_MN2WS_CKS			(0x04)
#define SPI_MN2WS_TXWDS			(0x08)
#define SPI_MN2WS_RXWDS			(0x0C)
#define SPI_MN2WS_FPS			(0x10)
#define SPI_MN2WS_SR			(0x14)
#define SPI_MN2WS_IE			(0x18)
#define SPI_MN2WS_IS			(0x1C)
#define SPI_MN2WS_IC			(0x1C)
#define SPI_MN2WS_FC			(0x20)
#define SPI_MN2WS_TXDR			(0x24)
#define SPI_MN2WS_RXDR			(0x24)
#define SPI_MN2WS_WTR			(0x3C)

/*----- SCSSInCTL -----*/
								//0000 0000 0000 0001
#define SPI_MN2WS_CTL_SSIEN		(0x0001)

/*----- SCSSInCKS -----*/
								//0100 0000 0000 0000
#define SPI_MN2WS_CKS_CKPHS		(0x4000)
								//0010 0000 0000 0000
#define SPI_MN2WS_CKS_CKINIT	(0x2000)
								//0001 0000 0000 0000
#define SPI_MN2WS_CKS_CKDLY		(0x1000)
								//0000 0000 1111 1111
#define SPI_MN2WS_CKS_CKRAT		(0x00FF)

/*----- SCSSInTXWDS -----*/
									//1100 0000 0000 0000
#define SPI_MN2WS_TXWDS_DTDLY	(0xC000)
									//0011 1111 0000 0000
#define SPI_MN2WS_TXWDS_WDLEN	(0x3F00)
									//0000 0000 1100 0000
#define SPI_MN2WS_TXWDS_TDTF	(0x00C0)
									//0000 0000 0011 1111
#define SPI_MN2WS_TXWDS_DTLEN	(0x003F)

/*----- SCSSInRXWDS -----*/
									//1100 0000 0000 0000
#define SPI_MN2WS_RXWDS_DTDLY	(0xC000)
									//0000 0000 1100 0000
#define SPI_MN2WS_RXWDS_RDTF	(0x00C0)
									//0000 0000 0011 1111
#define SPI_MN2WS_RXWDS_DTLEN	(0x003F)

/*----- SCSSInFPS -----*/
								//1000 0000 0000 0000
#define SPI_MN2WS_FPS_FSPOL		(0x8000)
								//0100 0000 0000 0000
#define SPI_MN2WS_FPS_FSTRT		(0x4000)
								//0000 0000 0011 1111
#define SPI_MN2WS_FPS_PWDTH		(0x003F)

/*----- SCSSInSR -----*/
								//0000 0000 1000 0000
#define SPI_MN2WS_SR_BUSY		(0x0080)
								//0000 0000 0010 0000
#define SPI_MN2WS_SR_TNF		(0x0020)
								//0000 0000 0001 0000
#define SPI_MN2WS_SR_TFE		(0x0010)
								//0000 0000 0000 0010
#define SPI_MN2WS_SR_RFE		(0x0002)
								//0000 0000 0000 0001
#define SPI_MN2WS_SR_RNE		(0x0001)

/*----- SCSSInIE -----*/
								//0000 0000 0001 0000
#define SPI_MN2WS_IE_TCIE		(0x0010)
								//0000 0000 0000 1000
#define SPI_MN2WS_IE_RCIE		(0x0008)
								//0000 0000 0000 0100
#define SPI_MN2WS_IE_TXIE		(0x0004)
								//0000 0000 0000 0010
#define SPI_MN2WS_IE_RXIE		(0x0002)
								//0000 0000 0000 0001
#define SPI_MN2WS_IE_RORIE		(0x0001)

/*----- SCSSInIS -----*/
								//0001 0000 0000 0000
#define SPI_MN2WS_IS_TCIS		(0x1000)
								//0000 1000 0000 0000
#define SPI_MN2WS_IS_RCIS		(0x0800)
								//0000 0100 0000 0000
#define SPI_MN2WS_IS_TXRS		(0x0400)
								//0000 0010 0000 0000
#define SPI_MN2WS_IS_RXRS		(0x0200)
								//0000 0001 0000 0000
#define SPI_MN2WS_IS_RORIS		(0x0100)
								//0000 0000 0001 0000
#define SPI_MN2WS_IS_TCID		(0x0010)
								//0000 0000 0000 1000
#define SPI_MN2WS_IS_RCID		(0x0008)
								//0000 0000 0000 0100
#define SPI_MN2WS_IS_TXRD		(0x0004)
								//0000 0000 0000 0010
#define SPI_MN2WS_IS_RXRD		(0x0002)
								//0000 0000 0000 0001
#define SPI_MN2WS_IS_RORID		(0x0001)

/*----- SCSSInIC -----*/
								//0000 0000 0001 0000
#define SPI_MN2WS_IC_TCIC		(0x0010)
								//0000 0000 0000 1000
#define SPI_MN2WS_IC_RCIC		(0x0008)
								//0000 0000 0000 0001
#define SPI_MN2WS_IC_RORIC		(0x0001)

/*----- SCSSInFC -----*/
								//0001 0000 0000 0000
#define SPI_MN2WS_FC_TXFFL		(0x1000)
								//0000 1111 0000 0000
#define SPI_MN2WS_FC_TXFTH		(0x0F00)
								//0000 0000 0001 0000
#define SPI_MN2WS_FC_RXFFL		(0x0010)
								//0000 0000 0000 1111
#define SPI_MN2WS_FC_RXFTH		(0x000F)

/*----- SCSSInTXDR(W) -----*/
								//1111 1111 1111 1111 1111 1111 1111 1111
#define SPI_MN2WS_TXDR_TXDT		(0xFFFFFFFF)

/*----- SCSSInRXDR(R) -----*/
								//1111 1111 1111 1111 1111 1111 1111 1111
#define SPI_MN2WS_TXDR_RXDT		(0xFFFFFFFF)

/*----- SCSSInWTR -----*/
								//0000 0000 0011 1111
#define SPI_MN2WS_WTR_CYCLE		(0x003F)

/*----- DUMMY DATA -----*/
#define TX_DUMMY_DATA			(0x00000000UL)
#ifdef DUMMY_allF
  #define TX_DUMMY_DATA			(0xFFFFFFFFUL)
#endif
#ifdef DUMMY_12345678
  #define TX_DUMMY_DATA			(0x12345678UL)
#endif
#ifdef DUMMY_B8A2E4F1
  #define TX_DUMMY_DATA			(0xB8A2E4F1UL)
#endif

#define SPI_MN2WS_0_IRQ			(71)
#define SPI_MN2WS_1_IRQ			(118)
#define SPI_MN2WS_ADAP_MAX		(2)
#define PORT_REG_BASE			(0x55000000UL)
#define PINS_REG_BASE			(0x5F801000UL)

#define P7IOD					(0x40)
#define P7DIR					(0x44)
#define P7_0_out				(0xfe)
#define P7_0_off				(0x01)
#define P7_0_on					(0xfe)
//sLD2
#define P3IOD					(0x20)
#define P3DIR					(0x24)
#define P16IOD					(0x88)
#define P16DIR					(0x8c)
#define P3_2_out				(0xfb)
#define P16_0_out				(0xfe)
#define P3_2_off				(0x04)
#define P16_0_off				(0x01)
#define P3_2_on					(0xfb)
#define P16_0_on				(0xfe)

#define XIRQ8_SYNC				(0x94)    /* bit 7-0   0:XIRQ8  2:SPISYNK  */
#define PORT32_SYNC				(0xb0)   /* bit 31-24 0:PORT32 2:SPISYNK2 */
#define PORT70_SYNC				(0x74)   /* 0x5f801074: bit 31-24 F:PORT71 2:SPISYNK2 */
#define XIRQ8_mode0				(0xffffff00)   
#define P32_mode0				(0x00ffffff)
#define P70_mask				(0xff00ffff) /* PINCTRL29 mask value for pinsel118 */
#define P70_modeF				(0x000f0000) /* PINCTRL29 setting value for pinsel 118 */

#define SPI_UDELAY				(20)  
#define SPI_TX_COUNT_MAX		(65000)  
#define SPI_RX_COUNT_MAX		(65000)  
#define SPI_STATUS_OK		(0)  
#define SPI_MODE_MAX		(3)  
#define SPI_DATA_SETTING_MIN	(0)  
#define SPI_DATA_SETTING_MAX	(1)  
#define SPI_DATA_DELAY_OVER	(3)  
#define SPI_DATA_FORMAT_MIN	(0)  
#define SPI_DATA_FORMAT_MAX	(3)  
#define SPI_BPW_MIN		(1)  
#define SPI_BPW_MAX		(32)  
#define SPI_CLK_DELAY_MIN	(0)  
#define SPI_CLK_DELAY_MAX	(1)  
#define SPI_CLK_RATE_MIN	(2)  
#define SPI_CLK_RATE_MAX	(255)  
#define SPI_CS_SETTING_MIN	(0)  
#define SPI_CS_SETTING_MAX	(1)  
#define SPI_WDLEN_MIN		(4)  
#define SPI_WDLEN_MAX		(63)  
#define SPI_PWDTH_MIN		(1)
#define SPI_PWDTH_MAX		(63)
#define CS_OFF			(0)  
#define CS_ON			(1)  
#define NEXT_OFF		(0)  
#define NEXT_ON			(1)  
#define SPI_CLK 		(MN_IOCLK / 2 )

struct spi_mn2ws_data{
	void				(*write32)(struct spi_mn2ws_data *spi, unsigned long reg, unsigned long val);
	unsigned long		(*read32)(struct spi_mn2ws_data *spi, unsigned long reg);
	unsigned long		base;				/* Register Base Address */
	void				*iomap_base;		/* IOREMAP : Register Base Address */
	unsigned long		pinsel_cs;			/* Register Pinsel SPISYNC */
	unsigned long		port_dir;			/* Register Port Direction */
	unsigned long		port_iod;			/* Register Port IO Data */
	unsigned long		data_dir;			/* Data Port Direction */
	unsigned long		cs_high;			/* Data Port IO Data */
	unsigned long		cs_low;				/* Data Port IO Data */
	unsigned long		data_iod;			/* Data Port IO Data */
	unsigned long		pinsel_mode;		/* Data Pinsel IO Data */
	void				*p_iomap_base;		/* IOREMAP : Register Port Base Address */
	void				*s_iomap_base;		/* IOREMAP : Register Pinsel Base Address */
	int					irq;				/* IRQ No. */
	int					irq_event;
	wait_queue_head_t	wait;				/* for IRQ handler */
	spinlock_t			lock;				/* lock for controller */
};

enum{
	SPI_READ,
	SPI_WRITE
};

enum{
	MN2WS_TX,
	MN2WS_RX,
	/* MN2WS_NONE */
	MN2WS_TXRX
};

enum{
	chip_select_0,
	chip_select_1
};

enum{
	SPI_MODE,
	LSB_FIRST,
	BITS_PER_WORD,
	CLK_DELAY,
	CLK_RATE,
	CS_POL,
	CS_STRT,
	WD_LEN,
	DATA_ORDER,
	DATA_DELAY,
	FIFO_TH,
	P_WDTH,
	DATA_FORMAT,
};

enum{
	/* for MODE */
	MN2WS_MODE0,
	MN2WS_MODE1,
	MN2WS_MODE2,
	MN2WS_MODE3
};

enum{
	/* for LSB_FIRST */
	MN2WS_MSB,
	MN2WS_LSB
};
enum{
	/* for DATA_ORDER */
	MN2WS_F_STUFF,
	MN2WS_P_STUFF
};
enum{
	/* for DATA_DELAY */
	MN2WS_D_NODLY,
	MN2WS_D_1DLY,
	MN2WS_D_2DLY,
};
enum{
	/* for CLK_DELAY */
	MN2WS_C_DLY,
	MN2WS_C_NODLY,
};
enum{
	/* for CS_POL */
	MN2WS_CSPOL_PEDGE,		/* Ω夬 */
	MN2WS_CSPOL_NEDGE,		/* Ω */
};

enum{
	/* for CS_STRT */
	MN2WS_CSSTRT_PEDGE,		/* Ω夬 */
	MN2WS_CSSTRT_NEDGE		/* Ω */
};
//yy
//#include <linux/spi/spi.h>
extern int	mn2ws_spi_get_clkrate(struct spi_device *spi);
extern void	spi_cs_set(struct spi_device *spi);
extern void	spi_cs_assert(struct spi_device *spi);
extern void	spi_cs_negate(struct spi_device *spi);
extern int	mn2ws_spi_set_reg(struct spi_device *spi, int item, int txrx, int set_val);
extern int	mn2ws_spi_get_reg(struct spi_device *spi, int item, int txrx, int *get_val);
extern void	mn2ws_spi_init_register(struct spi_device *spi );
extern int 	mn2ws_spi_device_check(struct spi_device *spi );

#endif /* ] SPI_MN2WS_INTERNAL_H__INCLLUDED */
